#ifndef __TPointerDeleter__
#define __TPointerDeleter__

/**
 * @cond
 */
#include "../Basics/CCountedObject.hpp"
using Exponent::Basics::CCountedObject;
/**
 * @endcond
 */

namespace Exponent
{
	namespace Collections
	{
		/**
		 * @class TPointerDeleter TPointerDeleter.hpp
		 * @brief Templated deleter of pointers
		 *
		 * @date 23/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: TPointerDeleter.hpp,v 1.9 2007/02/11 02:15:54 paul Exp $
		 */
		template<class TypeName> class TPointerDeleter : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

			/**
			 * Construction
			 */
			TPointerDeleter();

			/**
			 * Destruction
			 */
			virtual ~TPointerDeleter();

			/**
			 * Pointer is added (ie if you need to reference, do it here)
			 * @param pointer The pointer to add
			 */
			virtual void pointerAdded(TypeName *pointer) const = 0;

			/**
			 * Delete a pointer
			 * @param pointer The pointer to delete
			 */
			virtual void deletePointer(TypeName *pointer) const = 0;
		};

//	===========================================================================

		/**
		 * @class TObjectDeleter TPointerDeleter.hpp
		 * @brief Templated deleter of objects
		 *
		 * @date 23/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exponent.\n
		 * You may not redistribute the source files in any way (except compiled), unless expressly sanctioned by Exponent.\n
		 * All content is the Intellectual property of Exponent.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please email plugins@expdigital.co.uk
		 */
		template<class TypeName> class TObjectDeleter : public TPointerDeleter<TypeName>
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

			/**
			 * Construction
			 */
			TObjectDeleter();

			/**
			 * Destruction
			 */
			virtual ~TObjectDeleter();

			/**
			 * Pointer is added (ie if you need to reference, do it here)
			 * @param pointer The pointer to add
			 */
			virtual void pointerAdded(TypeName *pointer) const { }

			/**
			 * Delete a pointer
			 * @param pointer The pointer to delete
			 */
			virtual void deletePointer(TypeName *pointer) const;
		};

//	===========================================================================

		/**
		 * @class TObjectNuller TPointerDeleter.hpp
		 * @brief Templated nuller of objects
		 *
		 * @date 23/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exponent.\n
		 * You may not redistribute the source files in any way (except compiled), unless expressly sanctioned by Exponent.\n
		 * All content is the Intellectual property of Exponent.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please email plugins@expdigital.co.uk
		 */
		template<class TypeName> class TObjectNuller : public TPointerDeleter<TypeName>
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

			/**
			 * Construction
			 */
			TObjectNuller();

			/**
			 * Destruction
			 */
			virtual ~TObjectNuller();

			/**
			 * Pointer is added (ie if you need to reference, do it here)
			 * @param pointer The pointer to add
			 */
			virtual void pointerAdded(TypeName *pointer) const { }

			/**
			 * Delete a pointer
			 * @param pointer The pointer to delete
			 */
			virtual void deletePointer(TypeName *pointer) const;
		};

//	===========================================================================

		/**
		 * @class TCountedObjectDeleter TPointerDeleter.hpp
		 * @brief Templated deleter of objects
		 *
		 * @date 23/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exponent.\n
		 * You may not redistribute the source files in any way (except compiled), unless expressly sanctioned by Exponent.\n
		 * All content is the Intellectual property of Exponent.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please email plugins@expdigital.co.uk
		 */
		template<class TypeName> class TCountedObjectDeleter : public TPointerDeleter<TypeName>
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

			/**
			 * Construction
			 */
			TCountedObjectDeleter();

			/**
			 * Destruction
			 */
			virtual ~TCountedObjectDeleter();

			/**
			 * Pointer is added (ie if you need to reference, do it here)
			 * @param pointer The pointer to add
			 */
			virtual void pointerAdded(TypeName *pointer) const;

			/**
			 * Delete a pointer
			 * @param pointer The pointer to delete
			 */
			virtual void deletePointer(TypeName *pointer) const;
		};

//	===========================================================================

		/** @cond */

//	===========================================================================

		EXPONENT_TEMPLATE_CLASS_IMPLEMENTATION(TPointerDeleter<TypeName>, TypeName, CCountedObject);
		EXPONENT_TEMPLATE_CLASS_IMPLEMENTATION_TEMPLATE_PARENT(TObjectDeleter<TypeName>, TypeName, TPointerDeleter<TypeName>, TypeName);
		EXPONENT_TEMPLATE_CLASS_IMPLEMENTATION_TEMPLATE_PARENT(TObjectNuller<TypeName>, TypeName, TPointerDeleter<TypeName>, TypeName);
		EXPONENT_TEMPLATE_CLASS_IMPLEMENTATION_TEMPLATE_PARENT(TCountedObjectDeleter<TypeName>, TypeName, TPointerDeleter<TypeName>, TypeName);

//	===========================================================================
		template<class TypeName> TPointerDeleter<TypeName>::TPointerDeleter()
		{
			EXPONENT_CLASS_CONSTRUCTION(TPointerDeleter<TypeName>);
		}

//	===========================================================================
		template<class TypeName> TPointerDeleter<TypeName>::~TPointerDeleter()
		{
			EXPONENT_CLASS_DESTRUCTION(TPointerDeleter<TypeName>);
		}

//	===========================================================================
		template<class TypeName> TObjectDeleter<TypeName>::TObjectDeleter()
		{
			EXPONENT_CLASS_CONSTRUCTION(TObjectDeleter<TypeName>);
		}

//	===========================================================================
		template<class TypeName> TObjectDeleter<TypeName>::~TObjectDeleter()
		{
			EXPONENT_CLASS_DESTRUCTION(TObjectDeleter<TypeName>);
		}

//	===========================================================================
		template<class TypeName> void TObjectDeleter<TypeName>::deletePointer(TypeName *pointer) const
		{
			FREE_POINTER(pointer);
		}

//	===========================================================================
		template<class TypeName> TObjectNuller<TypeName>::TObjectNuller()
		{
			EXPONENT_CLASS_CONSTRUCTION(TObjectNuller<TypeName>);
		}

//	===========================================================================
		template<class TypeName> TObjectNuller<TypeName>::~TObjectNuller()
		{
			EXPONENT_CLASS_DESTRUCTION(TObjectNuller<TypeName>);
		}

//	===========================================================================
		template<class TypeName> void TObjectNuller<TypeName>::deletePointer(TypeName *pointer) const
		{
			NULL_POINTER(pointer);
		}

//	===========================================================================
		template<class TypeName> TCountedObjectDeleter<TypeName>::TCountedObjectDeleter()
		{
			EXPONENT_CLASS_CONSTRUCTION(TCountedObjectDeleter<TypeName>);
		}

//	===========================================================================
		template<class TypeName> TCountedObjectDeleter<TypeName>::~TCountedObjectDeleter()
		{
			EXPONENT_CLASS_DESTRUCTION(TCountedObjectDeleter<TypeName>);
		}

//	===========================================================================
		template<class TypeName> void TCountedObjectDeleter<TypeName>::pointerAdded(TypeName *pointer) const
		{
			if (pointer)
			{
				pointer->referenced();
			}
		}

//	===========================================================================
		template<class TypeName> void TCountedObjectDeleter<TypeName>::deletePointer(TypeName *pointer) const
		{
			FORGET_COUNTED_OBJECT(pointer);
		}

		/** @endcond */
	}
}
#endif		// End of TPointerDeleter.hpp